--
-- FillablePalletFix
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history:	v1.0 - 2016-10-29 - Initial implementation
-- 

if not Utils.FillablePalletFix20161029 then
	Utils.FillablePalletFix20161029 = true;

	local oldFunc = FillablePallet.createNode;
	FillablePallet.createNode = function(self, i3dFilename, xmlFilename)
		local xmlFile;
		
		if xmlFilename ~= nil then
			self.xmlFilename = xmlFilename;
			xmlFile = loadXMLFile("tempObjectXML", self.xmlFilename);
			i3dFilename = getXMLString(xmlFile, "object.filename");
			
			-- we use the xmlFile instead as that have the correct path.
			self.customEnvironment, self.baseDirectory = Utils.getModNameAndBaseDirectory(xmlFilename);
			
			if self.customEnvironment ~= nil then -- we are an mod
				i3dFilename = Utils.getFilename(i3dFilename, self.baseDirectory); -- fix the path
			end;
		else
			self.customEnvironment, self.baseDirectory = Utils.getModNameAndBaseDirectory(i3dFilename);
		end;
		
		self.i3dFilename = i3dFilename;
		local fillablePalletRoot = Utils.loadSharedI3DFile(i3dFilename);
		local FillablePalletId = getChildAt(fillablePalletRoot, 0);
		
		link(getRootNode(), FillablePalletId);
		delete(fillablePalletRoot);
		self:setNodeId(FillablePalletId);
		
		if xmlFile ~= nil then
			FillablePallet.loadObjectXML(self, xmlFile)
			delete(xmlFile);
		end;
	end;
end;